using System;
using System.Collections.Specialized;
using System.IO;
using BeWise.SharpBuilderTools.Utils;

namespace BeWise.SharpBuilderTools.Ant
{
	public abstract class BaseAnt
	{
		// *************************************************************************
		//                           Constructor
		// *************************************************************************

		public BaseAnt()
		{
		}

		// *************************************************************************
		//                               Protected
		// *************************************************************************

		protected virtual string GetAntExe(){
			return GetAntPath() + GetCommandLine();
		}

		protected abstract string GetAntPath ();

		protected abstract string GetCommandLine ();

		protected virtual bool GetIsInstalled (){
			return File.Exists(GetAntExe());
		}

		protected abstract string GetName ();

		// *************************************************************************
		//                                Public
		// *************************************************************************

		public abstract BaseAntProject CreateAntProject(string aFileName);

		public virtual bool IsAntFile(string aFileName){
        	return false;
		}

		public void Run(string[] aTargets, string aWorkingDir) {
			if (!IsInstalled) {
				throw new Exception("Error, you need to install " + Name);
			}

			RunProcess _RunProcess = new RunProcess();
			string[] _Params = new String[aTargets.Length +1];

			_Params[0] = CommandLine;

			for (int i=0; i == (aTargets.Length -1); i++)
				_Params[i + 1] = aTargets[i];

			_RunProcess.OnConsoleOutput += OnConsoleOutput;
            _RunProcess.OnRunCompleted += OnRunCompleted;
			_RunProcess.Run(_Params, aWorkingDir);
		}

		// *************************************************************************
		//                                Properties
		// *************************************************************************

		public string AntExe
		{
			get
			{
				return GetAntExe();
			}
		}

		public string AntPath
		{
			get
			{
				return GetAntPath();
			}
		}

		public string CommandLine
		{
			get
			{
				return GetCommandLine();
			}
		}

		public bool IsInstalled {
			get {
				return GetIsInstalled();
			}
		}

		public string Name
		{
			get
			{
				return GetName();
			}
		}

		// *************************************************************************
		//                                Events
		// *************************************************************************

		public event RunProcess.ConsoleOutputEvent OnConsoleOutput;
		public event EventHandler OnRunCompleted;

	}
}
